implementation module windowevent


//	Clean Object I/O library, version 1.1

//	windowevent defines the DeviceEventFunction for the window device.
//	This function is placed in a separate module because it is platform dependent.


import StdBool, StdInt, StdList, StdMisc, StdTuple
import clCrossCall, intrface, oswindow
import controldefaccess, devicefunctions, iostate, windowaccess, windowdefaccess


windoweventFatalError :: String String -> .x
windoweventFatalError function error
	= FatalError function "windowevent" error


/*	windowEvent filters the scheduler events that can be handled by this window device.
	For the time being no timer controls are added, so these events are ignored.
*/
windowEvent :: !(SchedulerEvent i o) !(IOSt .l .p) -> (!Bool,!Maybe (DeviceEvent i o),!SchedulerEvent i o,!IOSt .l .p)

windowEvent schedulerEvent=:(ScheduleOSEvent osEvent _) ioState
	| not (isWindowOSEvent osEvent)
	= (False,Nothing,schedulerEvent,ioState)
	# (tb,ioState)		= getIOToolbox ioState
	# (wDevice,ioState)	= IOStGetDevice WindowDevice ioState
	  windows			= WindowSystemStateGetWindowHandles wDevice
	  (myEvent,replyToOS,deviceEvent,windows,tb)
	  					= filterOSEvent osEvent windows tb
	# ioState			= IOStSetDevice (WindowSystemState windows) ioState
	# ioState			= setIOToolbox tb ioState
	  schedulerEvent	= if (isJust replyToOS) (ScheduleOSEvent osEvent (fromJust replyToOS)) schedulerEvent
	= (myEvent,deviceEvent,schedulerEvent,ioState)
where
	isWindowOSEvent :: !OSEvent -> Bool
	isWindowOSEvent {ccMsg}
		= case ccMsg of
			CcWmACTIVATE		-> True
			CcWmBUTTONCLICKED	-> True
			CcWmCLOSE			-> True
			CcWmCOMBOSELECT		-> True
			CcWmDEACTIVATE		-> True
			CcWmDRAWCONTROL		-> True
			CcWmGETMINMAXINFO	-> True
			CcWmKEYBOARD		-> True
			CcWmLOSEMODELESSDLOG-> True
			CcWmMOUSE			-> True
			CcWmPAINT			-> True
			CcWmSCROLLBARACTION	-> True
			CcWmSIZE			-> True
			_					-> False

windowEvent schedulerEvent=:(ScheduleMsgEvent msgEvent) ioState
	# (ioId,ioState)	= IOStGetIOId ioState
	| ioId<>recLoc.rlIOId || recLoc.rlDevice<>WindowDevice
	= (False,Nothing,schedulerEvent,ioState)
	# (wDevice,ioState)	= IOStGetDevice WindowDevice ioState
	  windows			= WindowSystemStateGetWindowHandles wDevice
	  (found,windows)	= hasWindowHandlesWindow (toWID recLoc.rlParentId) windows
	  deviceEvent		= if found (Just (ReceiverEvent msgEvent)) Nothing
	# ioState			= IOStSetDevice (WindowSystemState windows) ioState
	= (found,deviceEvent,schedulerEvent,ioState)
where
	recLoc				= getMsgEventRecLoc msgEvent

windowEvent schedulerEvent ioState
	= (False,Nothing,schedulerEvent,ioState)


/*	filterOSEvent filters the OSEvents that can be handled by this window device.
*/
filterOSEvent :: !OSEvent !(WindowHandles .ps) !*OSToolbox -> (!Bool,!Maybe [Int],!Maybe (DeviceEvent i o),!WindowHandles .ps,!*OSToolbox)

filterOSEvent {ccMsg=CcWmBUTTONCLICKED,p1=wPtr,p2=cPtr,p3=mods} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (able,wsH)			= getWindowStateHandleSelect wsH
	| not able
	= (True,Nothing,Nothing,setWindowHandlesWindow wsH windows,tb)
	# (wids,  wsH)			= getWindowStateHandleWIDS wsH
	  (itemNr,wsH)			= getControlsItemNr cPtr wsH
	  controlSelectInfo		= if (itemNr==0)	// itemNrs are always > 0
	  							Nothing
	  							(Just (ControlSelection {csWIDS		= wids
														,csItemNr	= itemNr
														,csItemPtr	= cPtr
														,csMoreData	= 0
														,csModifiers= toModifiers mods
														})
								)
	= (True,Nothing,controlSelectInfo,setWindowHandlesWindow wsH windows,tb)
where
	getControlsItemNr :: !OSWindowPtr !(WindowStateHandle .ps) -> (!Int,!WindowStateHandle .ps)
	getControlsItemNr cPtr wsH=:{wshHandle=Just {wlsHandle={whItems}}}
		= (snd (getControlsItemNr cPtr whItems),wsH)
	where
		getControlsItemNr :: !OSWindowPtr ![WElementHandle .ls .ps] -> (!Bool,!Int)
		getControlsItemNr cPtr [itemH:itemHs]
			# (found,itemNr)	= getControlItemNr cPtr itemH
			| found
			= (found,itemNr)
			= getControlsItemNr cPtr itemHs
		where
			getControlItemNr :: !OSWindowPtr !(WElementHandle .ls .ps) -> (!Bool,!Int)
			getControlItemNr cPtr (WListLSHandle itemHs)
				= getControlsItemNr cPtr itemHs
			getControlItemNr cPtr (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				= getControlsItemNr cPtr itemHs
			getControlItemNr cPtr (WChangeLSHandle wExH=:{wChangeItems=itemHs})
				= getControlsItemNr cPtr itemHs
			getControlItemNr cPtr (WItemHandle itemH=:{wItemPtr})
				| cPtr==wItemPtr
					= (True,itemNr)
				| itemKind==IsRadioControl
					= (Contains (\{radioItemPtr}->radioItemPtr==cPtr) (getWItemRadioInfo info).radioItems,itemNr)
				| itemKind==IsCheckControl
					= (Contains (\{checkItemPtr}->checkItemPtr==cPtr) (getWItemCheckInfo info).checkItems,itemNr)
				| itemSelect && itemH.wItemShow
					= getControlsItemNr cPtr itemH.wItems
					= (False,0)
			where
				info		= itemH.wItemInfo
				itemKind	= itemH.wItemKind
				itemSelect	= itemH.wItemSelect
				itemNr		= if itemSelect itemH.wItemNr 0
		getControlsItemNr _ _
			= (False,0)
	getControlsItemNr _ _
		= windoweventFatalError "getControlsItemNr" "window placeholder not expected"

filterOSEvent {ccMsg=CcWmCOMBOSELECT,p1=wPtr,p2=cPtr,p3=index} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (able,wsH)			= getWindowStateHandleSelect wsH
	| not able
	= (True,Nothing,Nothing,setWindowHandlesWindow wsH windows,tb)
	# (wids,  wsH)			= getWindowStateHandleWIDS wsH
	  (itemNr,wsH)			= getPopUpControlItemNr cPtr wsH
	  controlSelectInfo		= if (itemNr==0)	// itemNrs are always > 0
								Nothing
								(Just (ControlSelection {csWIDS		= wids
														,csItemNr	= itemNr
														,csItemPtr	= cPtr
														,csMoreData	= index+1
														,csModifiers= NoModifiers
														})
								)
	= (True,Nothing,controlSelectInfo,setWindowHandlesWindow wsH windows,tb)
where
	getPopUpControlItemNr :: !OSWindowPtr !(WindowStateHandle .ps) -> (!Int,!WindowStateHandle .ps)
	getPopUpControlItemNr cPtr wsH=:{wshHandle=Just {wlsHandle={whItems}}}
		= (snd (getPopUpControlsItemNr cPtr whItems),wsH)
	where
		getPopUpControlsItemNr :: !OSWindowPtr ![WElementHandle .ls .ps] -> (!Bool,!Int)
		getPopUpControlsItemNr cPtr [itemH:itemHs]
			# (found,itemNr)	= getPopUpControlItemNr cPtr itemH
			| found
			= (found,itemNr)
			= getPopUpControlsItemNr cPtr itemHs
		where
			getPopUpControlItemNr :: !OSWindowPtr !(WElementHandle .ls .ps) -> (!Bool,!Int)
			getPopUpControlItemNr cPtr (WListLSHandle itemHs)
				= getPopUpControlsItemNr cPtr itemHs
			getPopUpControlItemNr cPtr (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				= getPopUpControlsItemNr cPtr itemHs
			getPopUpControlItemNr cPtr (WChangeLSHandle wExH=:{wChangeItems=itemHs})
				= getPopUpControlsItemNr cPtr itemHs
			getPopUpControlItemNr cPtr (WItemHandle itemH=:{wItemPtr})
				| cPtr==wItemPtr
				= (True,if (itemKind==IsPopUpControl && itemSelect && itemShow) itemNr 0)
				| itemShow
				= getPopUpControlsItemNr cPtr itemH.wItems
				= (False,0)
			where
				itemNr		= itemH.wItemNr
				itemKind	= itemH.wItemKind
				itemSelect	= itemH.wItemSelect
				itemShow	= itemH.wItemShow
		getPopUpControlsItemNr _ _
			= (False,0)
	getPopUpControlItemNr _ _
		= windoweventFatalError "getPopUpControlItemNr" "window placeholder not expected"

filterOSEvent {ccMsg=CcWmDRAWCONTROL,p1=wPtr,p2=cPtr,p3=gc} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	# (controls,wsH)		= getUpdateControls cPtr wsH
	  updateInfo			= if (isEmpty controls)
								Nothing
								(Just (WindowUpdate {updWIDS=wids,updWindowArea=ZeroRect,updControls=controls,updGContext=Just gc}))
	= (True,Nothing,updateInfo,setWindowHandlesWindow wsH windows,tb)
where
	getUpdateControls :: !OSWindowPtr !(WindowStateHandle .ps) -> (![ControlUpdateInfo],!WindowStateHandle .ps)
	getUpdateControls cPtr wsH=:{wshHandle=Just {wlsHandle={whItems,whSize={w,h}}}}
		= (snd (getUpdateControls cPtr (0,0, w,h) whItems),wsH)
	where
		getUpdateControls :: !OSWindowPtr !Rect ![WElementHandle .ls .ps] -> (!Bool,![ControlUpdateInfo])
		getUpdateControls cPtr clipRect [itemH:itemHs]
			# (found,controls)	= getUpdateControl cPtr clipRect itemH
			| found
			= (found,controls)
			= getUpdateControls cPtr clipRect itemHs
		where
			getUpdateControl :: !OSWindowPtr !Rect !(WElementHandle .ls .ps) -> (!Bool,![ControlUpdateInfo])
			getUpdateControl cPtr clipRect (WListLSHandle itemHs)
				= getUpdateControls cPtr clipRect itemHs
			getUpdateControl cPtr clipRect (WExtendLSHandle wExH=:{wExtendItems=itemHs})
				= getUpdateControls cPtr clipRect itemHs
			getUpdateControl cPtr clipRect (WChangeLSHandle wExH=:{wChangeItems=itemHs})
				= getUpdateControls cPtr clipRect itemHs
			getUpdateControl cPtr clipRect (WItemHandle itemH=:{wItemPtr})
				| cPtr==wItemPtr
				= (True, [{cuItemNr=itemH.wItemNr,cuItemPtr=wItemPtr,cuArea=clipRect1}])
				| itemH.wItemShow
				= getUpdateControls cPtr clipRect1 itemH.wItems
				= (False,[])
			where
				clipRect1	= IntersectRects clipRect (PosSizeToRect itemH.wItemPos itemH.wItemSize)
		getUpdateControls _ _ _
			= (False,[])
	getUpdateControls _ _
		= windoweventFatalError "getUpdateControls" "placeholder not expected"

filterOSEvent {ccMsg=CcWmGETMINMAXINFO,p1=wPtr} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wKind,wsH)			= getWindowStateHandleWindowKind wsH
	| wKind==IsDialog		// This alternative should never occur
	= windoweventFatalError "filterOSEvent" "OSGetMinMaxInfo event generated for Dialog"
	# (minmaxInfo,wsH)		= getWindowStateHandleMinMaxInfo wsH
	= (True,Just minmaxInfo,Nothing,setWindowHandlesWindow wsH windows,tb)
where
	getWindowStateHandleMinMaxInfo :: !(WindowStateHandle .ps) -> (![Int],!WindowStateHandle .ps)
	getWindowStateHandleMinMaxInfo wsH=:{wshHandle=Just {wlsHandle={whWindowInfo,whAtts}}}
		| Contains iswindowresize whAtts
		= ([maxSize.w,maxSize.h,minSize.w,minSize.h],wsH)
		with
			minSize			= getwindowminimumsize (snd (Select iswindowminimumsize undef whAtts))
			maxSize			= rectangleSize (fromJust whWindowInfo).windowDomain
		= ([],wsH)
	getWindowStateHandleMinMaxInfo _
		= windoweventFatalError "getWindowStateHandleMinMaxInfo" "placeholder not expected"

filterOSEvent {ccMsg=CcWmSCROLLBARACTION,p1=wPtr,p2=cPtr,p3=iBar,p4=action,p5=osThumb} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (able,wsH)			= getWindowStateHandleSelect wsH
	| not able
	= (True,Nothing,Nothing,setWindowHandlesWindow wsH windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  (sliderEvent,wsH)		= getSlidersEvent wids iBar osThumb cPtr wsH
	= (True,Nothing,Just sliderEvent,setWindowHandlesWindow wsH windows,tb)
where
	getSlidersEvent :: WIDS Int Int !OSWindowPtr !(WindowStateHandle .ps) -> (!DeviceEvent i o,!WindowStateHandle .ps)
	getSlidersEvent wids iBar osThumb itemPtr wsH=:{wshHandle=Just {wlsHandle={whWindowInfo,whItems,whSize={w,h}}}}
		| wids.wPtr==itemPtr
		= (WindowScrollAction info,wsH)
		with
			info				= {	wsaWIDS			= wids
								  ,	wsaSliderMove	= move min max view osThumb
								  ,	wsaDirection	= if isHorizontal Horizontal Vertical
								  }
			windowInfo			= fromJust whWindowInfo
			domain				= windowInfo.windowDomain
			isHorizontal		= iBar==SB_HORZ
			(min,max,view)		= if isHorizontal
									(domain.corner1.x,domain.corner2.x,w)
									(domain.corner1.y,domain.corner2.y,h)
		# (found,sliderEvent)	= getSlidersEvent wids iBar osThumb itemPtr whItems
		| found
		= (sliderEvent,wsH)
		= windoweventFatalError "getSlidersEvent" "SliderControl could not be located"
	where
		getSlidersEvent :: WIDS Int Int !OSWindowPtr ![WElementHandle .ls .ps] -> (!Bool,DeviceEvent i o)
		getSlidersEvent wids iBar osThumb itemPtr [itemH:itemHs]
			# (found,sliderEvent)	= getSliderEvent wids iBar osThumb itemPtr itemH
			| found
			= (found,sliderEvent)
			= getSlidersEvent wids iBar osThumb itemPtr itemHs
		where
			getSliderEvent :: WIDS Int Int !OSWindowPtr !(WElementHandle .ls .ps) -> (!Bool,DeviceEvent i  o)
			getSliderEvent wids iBar osThumb itemPtr (WListLSHandle itemHs)
				= getSlidersEvent wids iBar osThumb itemPtr itemHs
			getSliderEvent wids iBar osThumb itemPtr (WExtendLSHandle {wExtendItems=itemHs})
				= getSlidersEvent wids iBar osThumb itemPtr itemHs
			getSliderEvent wids iBar osThumb itemPtr (WChangeLSHandle {wChangeItems=itemHs})
				= getSlidersEvent wids iBar osThumb itemPtr itemHs
			getSliderEvent wids iBar osThumb itemPtr (WItemHandle itemH=:{wItemPtr,wItemKind})
				| itemPtr<>itemH.wItemPtr
					| itemH.wItemShow
					= getSlidersEvent wids iBar osThumb itemPtr itemH.wItems
					= (False,undef)
				| wItemKind==IsCompoundControl
				= (True,CompoundScrollAction info)
				with
					info			= {	csaWIDS			= wids
									  ,	csaItemNr		= itemH.wItemNr
									  ,	csaItemPtr		= cPtr
									  ,	csaSliderMove	= move min max view osThumb
									  ,	csaDirection	= if isHorizontal Horizontal Vertical
									  }
					compoundSize	= itemH.wItemSize
					compoundInfo	= getWItemCompoundInfo itemH.wItemInfo
					domain			= compoundInfo.compoundDomain
					isHorizontal	= iBar==SB_HORZ
					(min,max,view)	= if isHorizontal
										(domain.corner1.x,domain.corner2.x,compoundSize.w)
										(domain.corner1.y,domain.corner2.y,compoundSize.h)
				= (True,ControlSliderAction info)
				with
					info			= {	cslWIDS			= wids
									  ,	cslItemNr		= itemH.wItemNr
									  ,	cslItemPtr		= cPtr
									  ,	cslSliderMove	= move sliderState.sliderMin sliderState.sliderMax 0 osThumb
									  }
					sliderInfo		= getWItemSliderInfo itemH.wItemInfo
					sliderState		= sliderInfo.sliderInfoState
		getSlidersEvent _ _ _ _ _
			= (False,undef)
	getSlidersEvent _ _ _ _ _
		= windoweventFatalError "getSlidersEvent" "placeholder not expected"
	
	move :: !Int !Int !Int !Int -> SliderMove
	move min max view osThumb
		= case action of
			SB_LINEUP		-> SliderDecSmall
			SB_LINEDOWN		-> SliderIncSmall
			SB_PAGEUP		-> SliderDecLarge
			SB_PAGEDOWN		-> SliderIncLarge
			SB_THUMBPOSITION-> SliderThumb (fromOSscrollbarRange (min,max) view osThumb)
			SB_THUMBTRACK	-> SliderThumb (fromOSscrollbarRange (min,max) view osThumb)
			SB_TOP			-> SliderThumb min
			SB_BOTTOM		-> SliderThumb (max-view)
			SB_ENDSCROLL	-> SliderThumb (fromOSscrollbarRange (min,max) view osThumb)

filterOSEvent {ccMsg=CcWmACTIVATE,p1=wPtr} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  windows				= setWindowHandlesWindow wsH windows
	= (True,Nothing,Just (WindowActivation wids),windows,tb)

filterOSEvent {ccMsg=CcWmCLOSE,p1=wPtr} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  windows				= setWindowHandlesWindow wsH windows
	= (True,Nothing,Just (WindowRequestClose wids),windows,tb)

filterOSEvent {ccMsg=CcWmDEACTIVATE,p1=wPtr} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  windows				= setWindowHandlesWindow wsH windows
	= (True,Nothing,Just (WindowDeactivation wids),windows,tb)

filterOSEvent {ccMsg=CcWmKEYBOARD,p1=wPtr,p2=cPtr,p3=keycode,p4=state,p5=mods} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	| wPtr==cPtr			// The keyboard action takes place in the window
	= (True,Nothing,deviceEvent,setWindowHandlesWindow wsH1 windows,tb)
	with
		(ok,key,wsH1)		= okWindowKeyboardState keycode state mods wsH
		deviceEvent			= if ok (Just (WindowKeyboardAction {wkWIDS=wids,wkKeyboardState=key})) Nothing
		
		okWindowKeyboardState :: !Int !Int !Int !(WindowStateHandle .ps) -> (!Bool,KeyboardState,!WindowStateHandle .ps)
		okWindowKeyboardState keycode state mods wsH=:{wshHandle=Just {wlsHandle={whKind,whWindowInfo,whAtts}}}
			| whKind==IsDialog
			= (False,undef,wsH)
			= (filter key && selectState==Able,key,wsH)
		where
			key						= keyState keycode state mods
			(filter,selectState,_)	= getwindowkeyboardinfo (snd (Select iswindowkeyboard (WindowKeyboard (const False) Unable undef) whAtts))
		okWindowKeyboardState _ _ _ _
			= windoweventFatalError "okWindowKeyboardState" "placeholder not expected"
	// The keyboard action takes place in a control
	= (True,Nothing,deviceEvent,setWindowHandlesWindow wsH1 windows,tb1)
	with
		(ok,itemNr,key,wsH1,tb1)= okControlItemsNrKeyboardState wPtr cPtr keycode state mods wsH tb
		deviceEvent				= if ok (Just (ControlKeyboardAction info)) Nothing
		info					= {	ckWIDS			= wids
								  ,	ckItemNr		= itemNr
								  ,	ckItemPtr		= cPtr
								  ,	ckKeyboardState	= key
								  }
		
		okControlItemsNrKeyboardState :: !OSWindowPtr !OSWindowPtr !Int !Int !Int !(WindowStateHandle .ps) !*OSToolbox
													  -> (!Bool,!Int,KeyboardState,!WindowStateHandle .ps, !*OSToolbox)
		okControlItemsNrKeyboardState wPtr itemPtr keycode state mods wsH=:{wshHandle=Just wlsH=:{wlsHandle=wH=:{whItems}}} tb
			# (_,ok,itemNr,itemPos,itemHs,tb)	= okControlsItemNrKeyboardState wPtr itemPtr True keycode state mods whItems tb
			= (ok,itemNr,itemPos,{wsH & wshHandle=Just {wlsH & wlsHandle={wH & whItems=itemHs}}},tb)
		where
			okControlsItemNrKeyboardState :: !OSWindowPtr !OSWindowPtr !Bool !Int !Int !Int ![WElementHandle .ls .ps] !*OSToolbox
														 -> (!Bool,!Bool,!Int,KeyboardState,![WElementHandle .ls .ps],!*OSToolbox)
			okControlsItemNrKeyboardState wPtr itemPtr contextAble keycode state mods [itemH:itemHs] tb
				# (found,ok,itemNr,itemPos,itemH,tb)	= okControlItemNrKeyboardState wPtr itemPtr contextAble keycode state mods itemH tb
				| found
				= (found,ok,itemNr,itemPos,[itemH:itemHs],tb)
				# (found,ok,itemNr,itemPos,itemHs,tb)	= okControlsItemNrKeyboardState wPtr itemPtr contextAble keycode state mods itemHs tb
				= (found,ok,itemNr,itemPos,[itemH:itemHs],tb)
			where
				okControlItemNrKeyboardState :: !OSWindowPtr !OSWindowPtr !Bool !Int !Int !Int !(WElementHandle .ls .ps) !*OSToolbox
															 -> (!Bool,!Bool,!Int,KeyboardState,!WElementHandle .ls .ps, !*OSToolbox)
				okControlItemNrKeyboardState wPtr itemPtr contextAble keycode state mods (WListLSHandle itemHs) tb
					# (found,ok,itemNr,itemPos,itemHs,tb)	= okControlsItemNrKeyboardState wPtr itemPtr contextAble keycode state mods itemHs tb
					= (found,ok,itemNr,itemPos,WListLSHandle itemHs,tb)
				okControlItemNrKeyboardState wPtr itemPtr contextAble keycode state mods (WExtendLSHandle wExH=:{wExtendItems=itemHs}) tb
					# (found,ok,itemNr,itemPos,itemHs,tb)	= okControlsItemNrKeyboardState wPtr itemPtr contextAble keycode state mods itemHs tb
					= (found,ok,itemNr,itemPos,WExtendLSHandle {wExH & wExtendItems=itemHs},tb)
				okControlItemNrKeyboardState wPtr itemPtr contextAble keycode state mods (WChangeLSHandle wChH=:{wChangeItems=itemHs}) tb
					# (found,ok,itemNr,itemPos,itemHs,tb)	= okControlsItemNrKeyboardState wPtr itemPtr contextAble keycode state mods itemHs tb
					= (found,ok,itemNr,itemPos,WChangeLSHandle {wChH & wChangeItems=itemHs},tb)
				okControlItemNrKeyboardState wPtr itemPtr contextAble keycode state mods (WItemHandle itemH=:{wItemPtr,wItemKind,wItemSelect,wItemAtts}) tb
					| itemPtr==wItemPtr
  						# noKeyboardAtt			= ControlKeyboard (const False) Unable undef
						  (filter,selectState,_)= getcontrolkeyboardinfo (snd (Select iscontrolkeyboard noKeyboardAtt wItemAtts))
						  key					= keyState keycode state mods
						= (True,contextAble1 && enabled selectState && filter key,itemH.wItemNr,key,WItemHandle itemH,tb)
					| not itemH.wItemShow
						= (False,False,0,undef,WItemHandle itemH,tb)
					# (found,ok,itemNr,itemPos,itemHs,tb)	= okControlsItemNrKeyboardState wPtr itemPtr contextAble1 keycode state mods itemH.wItems tb
					= (found,ok,itemNr,itemPos,WItemHandle {itemH & wItems=itemHs},tb)
				where
					contextAble1		= contextAble && wItemSelect
			okControlsItemNrKeyboardState _ _ _ _ _ _ itemH tb
				= (False,False,0,undef,itemH,tb)
		okControlItemsNrKeyboardState _ _ _ _ _ _ _
			= windoweventFatalError "okControlItemsNrKeyboardState" "window placeholder not expected"
where
	keyState :: !Int !Int !Int -> KeyboardState
	keyState keycode state mods
		| isSpecial
		= SpecialKey special ks modifiers
		= CharKey (toChar keycode) ks
	where
		modifiers			= toModifiers mods
		ks					= case state of
								KEYDOWN		-> KeyDown False
								KEYREPEAT	-> KeyDown True
								KEYUP		-> KeyUp
		(isSpecial,special)	= case keycode of
								WinHelpKey	-> (True,HelpKey)
								WinEscapeKey-> (True,EscapeKey)
								WinEnterKey	-> (True,EnterKey)
								WinDelKey	-> (True,DeleteKey)
								WinEndKey	-> (True,EndKey)
								WinBeginKey	-> (True,BeginKey)
								WinPgDownKey-> (True,PgDownKey)
								WinPgUpKey	-> (True,PgUpKey)
								WinRightKey	-> (True,RightKey)
								WinLeftKey	-> (True,LeftKey)
								WinDownKey	-> (True,DownKey)
								WinUpKey	-> (True,UpKey)
								WinF1Key	-> (True,F1Key)
								WinF2Key	-> (True,F2Key)
								WinF3Key	-> (True,F3Key)
								WinF4Key	-> (True,F4Key)
								WinF5Key	-> (True,F5Key)
								WinF6Key	-> (True,F6Key)
								WinF7Key	-> (True,F7Key)
								WinF8Key	-> (True,F8Key)
								WinF9Key	-> (True,F9Key)
								WinF10Key	-> (True,F10Key)
								WinF11Key	-> (True,F11Key)
								WinF12Key	-> (True,F12Key)
								_			-> (False,undef)

filterOSEvent {ccMsg=CcWmLOSEMODELESSDLOG,p1=wPtr} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  windows				= setWindowHandlesWindow wsH windows
	= (True,Nothing,Just (WindowRequestClose wids),windows,tb)

filterOSEvent {ccMsg=CcWmMOUSE,p1=wPtr,p2=cPtr,p3=action,p4=x,p5=y,p6=mods} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (able,wsH)			= getWindowStateHandleSelect wsH
	| not able
	= (True,Nothing,Nothing,setWindowHandlesWindow wsH windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	| wPtr==cPtr			// The mouse action takes place in the window
	= (True,Nothing,deviceEvent,setWindowHandlesWindow wsH1 windows,tb)
	with
		(ok,mouse,wsH1)		= okWindowMouseState action {x=x,y=y} wsH
		deviceEvent			= if ok (Just (WindowMouseAction {wmWIDS=wids,wmMouseState=mouse})) Nothing
		
		okWindowMouseState :: !Int !Point !(WindowStateHandle .ps) -> (!Bool,MouseState,!WindowStateHandle .ps)
		okWindowMouseState action eventPos wsH=:{wshHandle=Just {wlsHandle={whKind,whWindowInfo,whAtts}}}
			| whKind==IsDialog
			= (False,undef,wsH)
			= (filter mouse && selectState==Able,mouse,wsH)
		where
			origin					= (fromJust whWindowInfo).windowOrigin
			mouse					= mouseState action (eventPos+origin)
			(filter,selectState,_)	= getwindowmouseinfo (snd (Select iswindowmouse (WindowMouse (const False) Unable undef) whAtts))
		okWindowMouseState _ _ _
			= windoweventFatalError "okWindowMouseState" "placeholder not expected"
	// The mouse action takes place in a control
	= (True,Nothing,deviceEvent,setWindowHandlesWindow wsH1 windows,tb)
	with
		(ok,itemNr,mouse,wsH1)	= okControlItemsNrMouseState cPtr action {x=x,y=y} wsH
		deviceEvent				= if ok (Just (ControlMouseAction info)) Nothing
		info					= {	cmWIDS			= wids
								  ,	cmItemNr		= itemNr
								  ,	cmItemPtr		= cPtr
								  ,	cmMouseState	= mouse
								  }
		
		okControlItemsNrMouseState :: !OSWindowPtr !Int !Point !(WindowStateHandle .ps) -> (!Bool,!Int,MouseState,!WindowStateHandle .ps)
		okControlItemsNrMouseState itemPtr action eventPos wsH=:{wshHandle=Just {wlsHandle={whItems}}}
			# contextAble				= True
			#! (_,ok,itemNr,itemPos)	= okControlsItemNrMouseState contextAble itemPtr action eventPos whItems
			= (ok,itemNr,itemPos,wsH)
		where
			okControlsItemNrMouseState :: !Bool !OSWindowPtr !Int !Point ![WElementHandle .ls .ps] -> (!Bool,!Bool,!Int,MouseState)
			okControlsItemNrMouseState contextAble itemPtr action eventPos [itemH:itemHs]
				# (found,ok,itemNr,itemPos)	= okControlItemNrMouseState contextAble itemPtr action eventPos itemH
				| found
				= (found,ok,itemNr,itemPos)
				= okControlsItemNrMouseState contextAble itemPtr action eventPos itemHs
			where
				okControlItemNrMouseState :: !Bool !OSWindowPtr !Int !Point !(WElementHandle .ls .ps) -> (!Bool,!Bool,!Int,MouseState)
				okControlItemNrMouseState contextAble itemPtr action eventPos (WListLSHandle itemHs)
					= okControlsItemNrMouseState contextAble itemPtr action eventPos itemHs
				okControlItemNrMouseState contextAble itemPtr action eventPos (WExtendLSHandle {wExtendItems=itemHs})
					= okControlsItemNrMouseState contextAble itemPtr action eventPos itemHs
				okControlItemNrMouseState contextAble itemPtr action eventPos (WChangeLSHandle {wChangeItems=itemHs})
					= okControlsItemNrMouseState contextAble itemPtr action eventPos itemHs
				okControlItemNrMouseState contextAble itemPtr action eventPos (WItemHandle itemH=:{wItemPtr,wItemSelect,wItemAtts})
					| itemPtr==wItemPtr
					= (True,contextAble1 && enabled selectState && filter mouse,itemH.wItemNr,mouse)
					| itemH.wItemShow
					= okControlsItemNrMouseState contextAble1 itemPtr action eventPos itemH.wItems
					= (False,False,0,undef)
				where
					contextAble1			= contextAble && wItemSelect
					(filter,selectState,_)	= getcontrolmouseinfo (snd (Select iscontrolmouse (ControlMouse (const False) Unable undef) wItemAtts))
					mouse					= mouseState action eventPos
			okControlsItemNrMouseState _ _ _ _ _
				= (False,False,0,undef)
		okControlItemsNrMouseState _ _ _ _
			= windoweventFatalError "okControlItemsNrMouseState" "placeholder not expected"
where
	modifiers				= toModifiers mods
	nrDown					= case action of
								BUTTONDOWN			-> 1
								BUTTONDOUBLEDOWN	-> 2
							 	_					-> 3
	mouseState action pos	= case action of
								BUTTONSTILLUP		-> MouseMove pos modifiers
								BUTTONUP			-> MouseUp   pos modifiers
								BUTTONSTILLDOWN		-> MouseDrag pos modifiers
								_					-> MouseDown pos modifiers nrDown

filterOSEvent {ccMsg=CcWmSIZE,p1=wPtr,p2=w,p3=h} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wKind,wsH)			= getWindowStateHandleWindowKind wsH
	| wKind==IsDialog		// This alternative should never occur
	= windoweventFatalError "filterOSEvent" "WindowSizeAction event generated for Dialog"
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  (info,wsH,tb)			= getWindowStateHandleSize wids w h wsH tb
	  windows				= setWindowHandlesWindow wsH windows
	= (True,Nothing,Just (WindowSizeAction info),windows,tb)
where
	getWindowStateHandleSize :: !WIDS !Int !Int !(WindowStateHandle .ps) !*OSToolbox -> (!WindowSizeActionInfo,!WindowStateHandle .ps,!*OSToolbox)
	getWindowStateHandleSize wids newW newH wsH=:{wshHandle=Just {wlsHandle=wH}} tb
		# (wMetrics,tb)		= OSDefaultWindowMetrics tb
		  (visHScroll,visVScroll)
							= OSscrollbarsAreVisible wMetrics (RectangleToRect domain) (toTuple currentSize) (hasHScroll,hasVScroll)
		  newW				= if visVScroll (newW+wMetrics.osmVSliderWidth)  newW	// Correct newW in case of visible vertical   scrollbar
		  newH				= if visHScroll (newH+wMetrics.osmHSliderHeight) newH	// Correct newH in case of visible horizontal scrollbar
		  sizeInfo			= {wsWIDS=wids,wsSize={w=newW,h=newH}}
		= (sizeInfo,wsH,tb)
	where
		currentSize			= wH.whSize
		windowInfo			= fromJust wH.whWindowInfo
		domain				= windowInfo.windowDomain
		hasHScroll			= isJust windowInfo.windowHScroll
		hasVScroll			= isJust windowInfo.windowVScroll
	getWindowStateHandleSize _ _ _ _ _
		= windoweventFatalError "getWindowStateHandleSize" "placeholder not expected"

filterOSEvent {ccMsg=CcWmPAINT,p1=wPtr,p2=left,p3=top,p4=right,p5=bottom,p6=gc} windows tb
	# (found,wsH,windows)	= getWindowHandlesWindow (toWID wPtr) windows
	| not found
	= (False,Nothing,Nothing,windows,tb)
	# (wids,wsH)			= getWindowStateHandleWIDS wsH
	  windows				= setWindowHandlesWindow wsH windows
	  updRect				= (left,top,right,bottom)
	  updateInfo			= {updWIDS=wids,updWindowArea=updRect,updControls=[],updGContext=if (gc==0) Nothing (Just gc)}
	= (True,Nothing,Just (WindowUpdate updateInfo),windows,tb)

filterOSEvent _ _ _
	= windoweventFatalError "filterOSEvent" "unmatched OSEvent"


toModifiers :: !Int -> Modifiers
toModifiers i
	=	{	shiftDown	= shifton
		,	optionDown	= alton
		,	commandDown	= ctrlon
		,	controlDown	= ctrlon
		,	altDown		= alton
		}
where
	shifton	= i bitand SHIFTBIT <> 0
	alton	= i bitand ALTBIT   <> 0
	ctrlon	= i bitand CTRLBIT  <> 0
